package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowModifyRemarkResponse;

/**
 * @author dyl
 * 修改合同备注
 */
public class GetSignFlowModifyRemarkReq extends BaseRequest<GetSignFlowModifyRemarkResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/contract/modify";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowModifyRemarkResponse> getResponseType() {
        return GetSignFlowModifyRemarkResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;
    @RequestField(value="备注")
    private String remark;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
