package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowIdResponse;

/**
 * @author dyl
 * 合同详细信息查询
 */
public class GetSignFlowIdReq extends BaseRequest<GetSignFlowIdResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/info";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowIdResponse> getResponseType() {
        return GetSignFlowIdResponse.class;
    }

    @RequestField(value="流程编码")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
