package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.dto.FillComponentCmd;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowFillResponse;

import java.util.List;

/**
 * @author dyl
 * 填写合同
 */
public class GetSignFlowFillReq extends BaseRequest<GetSignFlowFillResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/fillSignForm";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowFillResponse> getResponseType() {
        return GetSignFlowFillResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;

    @RequestField(value="组件列表")
    public List<FillComponentCmd> components;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public List<FillComponentCmd> getComponents() {
        return components;
    }

    public void setComponents(List<FillComponentCmd> components) {
        this.components = components;
    }
}
