package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseDownloadRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowExportResponse;

import java.util.Date;
import java.util.List;

/**
 * @author dyl
 * 合同分页列表导出
 */
public class GetSignFlowExportReq extends BaseDownloadRequest {

    @Override
    public String getApiPath() {
        return "/signTask/contract/export";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class getResponseType() {
        return null;
    }


    @RequestField(value="查询类型 0-全部合同 1-我收到的 2-我发起的 3-抄送我的 4-待我操作 5-待他人操作 6-已完成 7-批量合同 8-草稿")
    private int docQueryType;

    @RequestField(value="流程编码")
    private String flowCode;

    @RequestField(value="签署流程标题")
    private String flowTitle;

    @RequestField(value="流程状态: 0 - 草稿; 1-填写 ;2 - 签署中; 3 - 完成; 4 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签")
    private Integer flowStatus;

    @RequestField(value="支持多个状态查询")
    private List<Integer> flowStatusList;

    @RequestField(value="手机号查找")
    private String mobile;

    @RequestField(value="查询类型 1-签署方企业 0-签署方姓名")
    private Integer participantType;

    @RequestField(value="签署方名称")
    private String participantName;

    @RequestField(value = "签署流程类型(0：正常签署流程；1：批次签署流程；2: 临时流程,对方通过小程序登录后可以更换手机号)")
    private Integer flowType;

    @RequestField(value="查询时间类型； 发起时间 0，完成时间 1，截止时间 2 三个")
    private int queryTimeType;

    @RequestField(value="签署流程开启时间")
    private Date flowStartTime;

    @RequestField(value="签署流程结束时间")
    private Date flowFinishTime;

    public int getDocQueryType() {
        return docQueryType;
    }

    public void setDocQueryType(int docQueryType) {
        this.docQueryType = docQueryType;
    }

    public String getFlowCode() {
        return flowCode;
    }

    public void setFlowCode(String flowCode) {
        this.flowCode = flowCode;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public List<Integer> getFlowStatusList() {
        return flowStatusList;
    }

    public void setFlowStatusList(List<Integer> flowStatusList) {
        this.flowStatusList = flowStatusList;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public String getParticipantName() {
        return participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public Integer getFlowType() {
        return flowType;
    }

    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    public int getQueryTimeType() {
        return queryTimeType;
    }

    public void setQueryTimeType(int queryTimeType) {
        this.queryTimeType = queryTimeType;
    }

    public Date getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(Date flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public Date getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(Date flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }
}
