package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCorpInfoResponse;

/**
 * @author dyl
 * 企业合同详情信息
 */
public class GetSignFlowCorpInfoReq extends BaseRequest<GetSignFlowCorpInfoResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/enterpriseContracts/info";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowCorpInfoResponse> getResponseType() {
        return GetSignFlowCorpInfoResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
