package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.dto.SignComponentCmd;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowContractResponse;

import java.util.List;

/**
 * @author dyl
 * 填写签署
 */
public class GetSignFlowContractReq extends BaseRequest<GetSignFlowContractResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/signContract";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowContractResponse> getResponseType() {
        return GetSignFlowContractResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;

    @RequestField(value="组件列表")
    public List<SignComponentCmd> components;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public List<SignComponentCmd> getComponents() {
        return components;
    }

    public void setComponents(List<SignComponentCmd> components) {
        this.components = components;
    }
}
