package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowContractFileResponse;

/**
 * @author dyl
 * 合同文档文件列表查询服务
 */
public class GetSignFlowContractFileReq extends BaseRequest<GetSignFlowContractFileResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/signFlowContractFile/list";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowContractFileResponse> getResponseType() {
        return GetSignFlowContractFileResponse.class;
    }


    @RequestField(value="文件id")
    private Long fileId;

    @RequestField(value="流程ID")
    private Long flowId;

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
