package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentQueryResponse;

/**
 * @author dyl
 * 查询填写信息
 */
public class GetSignFlowComponentQueryReq extends BaseRequest<GetSignFlowComponentQueryResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/fillComponentList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowComponentQueryResponse> getResponseType() {
        return GetSignFlowComponentQueryResponse.class;
    }


    @RequestField(value="流程ID")
    private Long flowId;


    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
