package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowComponentDetailQueryResponse;

/**
 * @author dyl
 * 合同文件查询服务组件信息
 */
public class GetSignFlowComponentDetailQueryReq extends BaseRequest<GetSignFlowComponentDetailQueryResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/signFlowContractFile/componentInfoList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowComponentDetailQueryResponse> getResponseType() {
        return GetSignFlowComponentDetailQueryResponse.class;
    }


    @RequestField(value="文件id")
    private Long fileId;


    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

}
