package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowCancelResponse;

/**
 * @author dyl
 * 撤销合同
 */
public class GetSignFlowCancelReq  extends BaseRequest<GetSignFlowCancelResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/contract/cancel";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowCancelResponse> getResponseType() {
        return GetSignFlowCancelResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;
    @RequestField(value="取消原因")
    private String cancelMsg;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getCancelMsg() {
        return cancelMsg;
    }

    public void setCancelMsg(String cancelMsg) {
        this.cancelMsg = cancelMsg;
    }
}
