package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowByMobileResponse;

import java.util.Date;
import java.util.List;

/**
 * @author dyl
 * 根据手机号查询合同列表
 */
public class GetSignFlowByMobileReq extends BasePageRequest<GetSignFlowByMobileResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/contract/listByMobile";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowByMobileResponse> getResponseType() {
        return GetSignFlowByMobileResponse.class;
    }

    @RequestField(value="当前流程状态: 0 - 草稿; 1 - 签署中; 2 - 完成; 3 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签")
    private Integer flowStatus;
    @RequestField(value="支持多个状态查询")
    private List<Integer> flowStatusList;

    @RequestField(value="账号查找（签署方账号）")
    private String mobile;

    @RequestField(value="查询时间类型； 发起时间 0，完成时间 1，截止时间 2 三个")
    private int queryTimeType;

    @RequestField(value="签署流程开启时间")
    private Date flowStartTime;

    @RequestField(value="签署流程结束时间")
    private Date flowFinishTime;

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public List<Integer> getFlowStatusList() {
        return flowStatusList;
    }

    public void setFlowStatusList(List<Integer> flowStatusList) {
        this.flowStatusList = flowStatusList;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public int getQueryTimeType() {
        return queryTimeType;
    }

    public void setQueryTimeType(int queryTimeType) {
        this.queryTimeType = queryTimeType;
    }

    public Date getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(Date flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public Date getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(Date flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }
}
