package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowAttachmentFileResponse;

/**
 * @author dyl
 * 合同附件文件信息查询
 */
public class GetSignFlowAttachmentFileReq extends BaseRequest<GetSignFlowAttachmentFileResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/attachmentFileInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowAttachmentFileResponse> getResponseType() {
        return GetSignFlowAttachmentFileResponse.class;
    }

    @RequestField(value="流程附件文件id")
    private Long attachmentId;

    public Long getAttachmentId() {
        return attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }
}
