package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetReversePayContractFeeResponse;

/**
 * @author dyl
 * 对方付合同费用支付
 */
public class GetReversePayContractFeeReq extends BaseRequest<GetReversePayContractFeeResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/reversePayContractFee";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetReversePayContractFeeResponse> getResponseType() {
        return GetReversePayContractFeeResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;


    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }


}
