package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetFetchSignerByShortCodeResponse;

/**
 * @author dyl
 * 根据短码查询合同参与方信息
 */
public class GetFetchSignerByShortCodeReq extends BaseRequest<GetFetchSignerByShortCodeResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/fetchSignerByShortCode";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetFetchSignerByShortCodeResponse> getResponseType() {
        return GetFetchSignerByShortCodeResponse.class;
    }


    @RequestField(value="流程编码")
    private String flowId;

    public String getFlowId() {
        return flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

}
