package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.TemplateComponentReq;
import com.yunyinsign.api.sdk.response.sign.GetDirectComponentSignFlowResponse;

import java.util.List;

/**
 * @author dyl
 * 指定签署位置直接发起合同
 */
public class GetDirectComponentSignFlowReq extends BaseRequest<GetDirectComponentSignFlowResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/directComponentSignFlow";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetDirectComponentSignFlowResponse> getResponseType() {
        return GetDirectComponentSignFlowResponse.class;
    }

    @RequestField(value="模板ID")
    private Long templateId;
    /**
     * 组件列表
     */
    @RequestField(value="组件实体类")
    public List<TemplateComponentReq> components;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<TemplateComponentReq> getComponents() {
        return components;
    }

    public void setComponents(List<TemplateComponentReq> components) {
        this.components = components;
    }
}
