package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetDesignatedSignatureUrlResponse;

/**
 * @author dyl
 * 获取指定签署位置直接发起合同链接
 */
public class GetDesignatedSignatureUrlReq extends BaseRequest<GetDesignatedSignatureUrlResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/getDesignatedSignatureUrl";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetDesignatedSignatureUrlResponse> getResponseType() {
        return GetDesignatedSignatureUrlResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
