package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetDelSignFlowResponse;

/**
 * @author dyl
 * 删除合同
 */
public class GetDelSignFlowReq extends BaseRequest<GetDelSignFlowResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/contract/del";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetDelSignFlowResponse> getResponseType() {
        return GetDelSignFlowResponse.class;
    }

    @RequestField(value="流程ID")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }


}
