package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.ApprovalSignResponse;

/**
 * @author dyl
 * 审批合同用章
 */
public class ApprovalSignReq extends BaseRequest<ApprovalSignResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/approvalSign";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<ApprovalSignResponse> getResponseType() {
        return ApprovalSignResponse.class;
    }

    @RequestField(value="审批申请ID")
    private Long approvalId;

    @RequestField(value="审批状态（1-审批中；2-审批通过；3-审批驳回；4-审批撤回；5-审批终止（超时未审批））")
    private Integer approvalStatus;

    @RequestField(value="驳回原因")
    private String failReason;


    public Long getApprovalId() {
        return approvalId;
    }

    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    public Integer getApprovalStatus() {
        return approvalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }
}
