package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.ApprovalQueryResponse;

import java.util.Date;

/**
 * @author dyl
 * 获取审批管理列表
 */
public class ApprovalQueryReq extends BasePageRequest<ApprovalQueryResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/getApprovalList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<ApprovalQueryResponse> getResponseType() {
        return ApprovalQueryResponse.class;
    }

    @RequestField(value="审批查询类型 0-待我审批 1-我已审批 2-我发起的 3-我收到的")
    private Integer docQueryType;

    @RequestField(value="审批类型 审核类型(1: 合同用章审批),2 合同审批")
    private Integer approvalType;

    @RequestField(value="合同名称")
    private String signFlowName;

    @RequestField(value="审批人id")
    private Long approvalPsnId;

    @RequestField(value="发起人id")
    private Long initiatorId;

    @RequestField(value="是否收款合同（0：否；1：收款合同）")
    private Integer payeeContractFlag;

    @RequestField(value="参与人名称")
    private String participantName;

    @RequestField(value="审批状态（1-审批中；2-审批通过；3-审批驳回；4-审批撤回；5-审批终止（超时未审批））")
    private Integer approvalStatus;

    @RequestField(value="合同时间类型； 审批发起时间 0;最新处理时间 1")
    private Integer queryTimeType;

    @RequestField(value="开始时间")
    private Date approvalTimeStart;

    @RequestField(value="结束时间")
    private Date approvalTimeEnd;

    public Integer getDocQueryType() {
        return docQueryType;
    }

    public void setDocQueryType(Integer docQueryType) {
        this.docQueryType = docQueryType;
    }

    public Integer getApprovalType() {
        return approvalType;
    }

    public void setApprovalType(Integer approvalType) {
        this.approvalType = approvalType;
    }

    public String getSignFlowName() {
        return signFlowName;
    }

    public void setSignFlowName(String signFlowName) {
        this.signFlowName = signFlowName;
    }

    public Long getApprovalPsnId() {
        return approvalPsnId;
    }

    public void setApprovalPsnId(Long approvalPsnId) {
        this.approvalPsnId = approvalPsnId;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public String getParticipantName() {
        return participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public Integer getApprovalStatus() {
        return approvalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public Integer getQueryTimeType() {
        return queryTimeType;
    }

    public void setQueryTimeType(Integer queryTimeType) {
        this.queryTimeType = queryTimeType;
    }

    public Date getApprovalTimeStart() {
        return approvalTimeStart;
    }

    public void setApprovalTimeStart(Date approvalTimeStart) {
        this.approvalTimeStart = approvalTimeStart;
    }

    public Date getApprovalTimeEnd() {
        return approvalTimeEnd;
    }

    public void setApprovalTimeEnd(Date approvalTimeEnd) {
        this.approvalTimeEnd = approvalTimeEnd;
    }
}
