package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.ApprovalInfoQueryResponse;

/**
 * @author dyl
 * 获取审批管理详情
 */
public class ApprovalInfoQueryReq extends BaseRequest<ApprovalInfoQueryResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/getApprovalInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<ApprovalInfoQueryResponse> getResponseType() {
        return ApprovalInfoQueryResponse.class;
    }

    @RequestField(value="审批申请ID")
    private Long approvalId;

    public Long getApprovalId() {
        return approvalId;
    }

    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }
}
