package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.core.BaseFileUploadRequest;
import com.yunyinsign.api.sdk.response.seal.UploadSealFileResponse;

/**
 * @author dyl
 * 上传印章图片文件
 */
public class UploadSealFileReq extends BaseFileUploadRequest<UploadSealFileResponse> {

    @Override
    public String getApiPath() {
        return "/seal/uploadSealFile";
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<UploadSealFileResponse> getResponseType() {
        return UploadSealFileResponse.class;
    }

    public static UploadSealFileReq create(byte[] fileBytes, String fileName) {
        UploadSealFileReq request = new UploadSealFileReq();
        request.setFileBytes(fileBytes);
        request.setFileName(fileName);
        return request;
    }

    public static UploadSealFileReq create(byte[] fileBytes, String fileName, String color) {
        UploadSealFileReq request = create(fileBytes, fileName);
        if (color != null && !color.trim().isEmpty()) {
            request.addFormParam("color", color);
        }
        return request;
    }

}
