package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.UpdDefaultSealResponse;

/**
 * @author dyl
 * 设置默认印章
 */
public class UpdDefaultSealReq extends BaseRequest<UpdDefaultSealResponse> {

    @Override
    public String getApiPath() {
        return "/seal/updDefault";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<UpdDefaultSealResponse> getResponseType() {
        return UpdDefaultSealResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;


    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

}
