package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.SealFilePreViewResponse;

/**
 * @author dyl
 * 预览图片印章
 */
public class SealFilePreViewReq extends BaseRequest<SealFilePreViewResponse> {

    @Override
    public String getApiPath() {
        return "/seal/uploadSealFilePreView";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<SealFilePreViewResponse> getResponseType() {
        return SealFilePreViewResponse.class;
    }


    @RequestField("源文件名称")
    private String fileName;

    @RequestField("文件路径 */")
    private String httpUrl;

    @RequestField("印章颜色；颜色：目前支持红色、蓝色、黑色、紫色，默认印章颜色是红色；Red, blue, black, purple")
    private String sealColor;

    @RequestField("透明度 0.0到1.0之间")
    private Float sealAlpha;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getSealColor() {
        return sealColor;
    }

    public void setSealColor(String sealColor) {
        this.sealColor = sealColor;
    }

    public Float getSealAlpha() {
        return sealAlpha;
    }

    public void setSealAlpha(Float sealAlpha) {
        this.sealAlpha = sealAlpha;
    }
}
