package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.GetSealQueryResponse;

/**
 * @author dyl
 * 获取印章信息
 */
public class GetSealQueryReq extends BaseRequest<GetSealQueryResponse> {

    @Override
    public String getApiPath() {
        return "/seal/getSealInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    @Override
    public Class<GetSealQueryResponse> getResponseType() {
        return GetSealQueryResponse.class;
    }
    @RequestField("印章ID")
    private Long sealId;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }
}
