package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.GetSealListResponse;

/**
 * @author dyl
 * 查询印章列表(分页)
 */
public class GetSealListReq extends BasePageRequest<GetSealListResponse> {
    @Override
    public String getApiPath() {
        return "/seal/getSealListByPage";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSealListResponse> getResponseType() {
        return GetSealListResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;

    @RequestField("印章名称，最大50个字符")
    private String sealName;

    @RequestField("印章类型：PUBLIC - 公章; CONTRACT - 合同专用章; FINANCE - 财务专用章; HR - 人事专用章; LEGAL_PERSON - 法定代表人章; OTHER - 其他")
    private String categoryType;

    @RequestField("印章状态:  1 - 已启用，2 - 待审核， 3 - 审核不通过，4 - 挂起")
    private Integer sealStatus;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public Integer getSealStatus() {
        return sealStatus;
    }

    public void setSealStatus(Integer sealStatus) {
        this.sealStatus = sealStatus;
    }
}
