package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.GetSealAuthorListResponse;

/**
 * @author dyl
 * 获取印章授权列表
 */
public class GetSealAuthorListReq extends BasePageRequest<GetSealAuthorListResponse> {
    @Override
    public String getApiPath() {
        return "/seal/getSealAuthorList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSealAuthorListResponse> getResponseType() {
        return GetSealAuthorListResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }
}
