package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.GetModifySealResponse;

/**
 * @author dyl
 * 修改印章名称
 */
public class GetModifySealReq extends BaseRequest<GetModifySealResponse> {

    @Override
    public String getApiPath() {
        return "/seal/modify";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetModifySealResponse> getResponseType() {
        return GetModifySealResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;

    @RequestField("印章名称")
    private String sealName;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }
}
