package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.DeleteSealResponse;

/**
 * @author dyl
 * 删除印章
 */
public class DeleteSealReq extends BaseRequest<DeleteSealResponse> {

    @Override
    public String getApiPath() {
        return "/seal/delete";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<DeleteSealResponse> getResponseType() {
        return DeleteSealResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;


    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

}
