package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.CreateSealByTemplateResponse;

/**
 * @author dyl
 * 创建模板印章
 */
public class CreateSealByTemplateReq extends BaseRequest<CreateSealByTemplateResponse> {

    @Override
    public String getApiPath() {
        return "/seal/createSealByTemplate";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<CreateSealByTemplateResponse> getResponseType() {
        return CreateSealByTemplateResponse.class;
    }


    @RequestField("印章名称")
    private String sealName;

    @RequestField("印章制作方式: 1 - 机构模板章，3 - 图片印章（上传本地文件）")
    private Integer sealStyle;

    @RequestField("印章类型：PUBLIC - 公章; CONTRACT - 合同专用章; FINANCE - 财务专用章; HR - 人事专用章; LEGAL_PERSON - 法定代表人章; OTHER - 其他")
    private String categoryType;

    @RequestField("印章样式，默认值：圆形章（round） 椭圆章（oval）")
    private String sealTemplateStyle;

    @RequestField("印章横排文字")
    private String sealHorizontalText;

    @RequestField("印章下弦文（实体印章防伪码）")
    private String sealBottomText;

    @RequestField("印章颜色；颜色：目前支持红色、蓝色、黑色、紫色，默认印章颜色是红色；Red, blue, black, purple")
    private String sealColor;

    @RequestField("透明度 0.0到1.0之间")
    private Float sealAlpha;

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public Integer getSealStyle() {
        return sealStyle;
    }

    public void setSealStyle(Integer sealStyle) {
        this.sealStyle = sealStyle;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getSealTemplateStyle() {
        return sealTemplateStyle;
    }

    public void setSealTemplateStyle(String sealTemplateStyle) {
        this.sealTemplateStyle = sealTemplateStyle;
    }

    public String getSealHorizontalText() {
        return sealHorizontalText;
    }

    public void setSealHorizontalText(String sealHorizontalText) {
        this.sealHorizontalText = sealHorizontalText;
    }

    public String getSealBottomText() {
        return sealBottomText;
    }

    public void setSealBottomText(String sealBottomText) {
        this.sealBottomText = sealBottomText;
    }

    public String getSealColor() {
        return sealColor;
    }

    public void setSealColor(String sealColor) {
        this.sealColor = sealColor;
    }

    public Float getSealAlpha() {
        return sealAlpha;
    }

    public void setSealAlpha(Float sealAlpha) {
        this.sealAlpha = sealAlpha;
    }
}
