package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.CreateSealByImageResponse;

/**
 * @author dyl
 * 创建图片印章
 */
public class CreateSealByImageReq extends BaseRequest<CreateSealByImageResponse> {

    @Override
    public String getApiPath() {
        return "/seal/createSealByImage";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<CreateSealByImageResponse> getResponseType() {
        return CreateSealByImageResponse.class;
    }


    @RequestField("印章名称")
    private String sealName;

    @RequestField("印章制作方式: 1 - 机构模板章，3 - 图片印章（上传本地文件）")
    private Integer sealStyle;

    @RequestField("印章类型：PUBLIC - 公章; CONTRACT - 合同专用章; FINANCE - 财务专用章; HR - 人事专用章; LEGAL_PERSON - 法定代表人章; OTHER - 其他")
    private String categoryType;

    @RequestField("印章样式，默认值：圆形章（round） 椭圆章（oval）")
    private String sealTemplateStyle;

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public Integer getSealStyle() {
        return sealStyle;
    }

    public void setSealStyle(Integer sealStyle) {
        this.sealStyle = sealStyle;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getSealTemplateStyle() {
        return sealTemplateStyle;
    }

    public void setSealTemplateStyle(String sealTemplateStyle) {
        this.sealTemplateStyle = sealTemplateStyle;
    }
}
