package com.yunyinsign.api.sdk.request.seal;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.seal.CreateSealAuthorResponse;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author dyl
 * 新增印章授权
 */
public class CreateSealAuthorReq extends BaseRequest<CreateSealAuthorResponse> {

    @Override
    public String getApiPath() {
        return "/seal/addSealAuthor";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<CreateSealAuthorResponse> getResponseType() {
        return CreateSealAuthorResponse.class;
    }


    @RequestField("印章ID")
    private Long sealId;

    @RequestField("授权对象(0：全部企业成员；1：指定企业人员)；授权对象，“指定企业人员”，支持。而“全部企业成员” 不支持。")
    private Integer authorMemberRange;

    @RequestField("会员信息")
    private List<UserInfo> userIdList;

    @RequestField("授权角色：SEAL_USER - 印章使用员（印章使用权限）；SEAL_EXAMINER - 印章审批员（印章使用权限+用印审批权限）")
    private String authorRole;

    @RequestField("授权范围(0：全部合同；1：指定模板)")
    private Integer authorRange;

    @RequestField("指定模板时指定的模板（最大10个模板）,模板的id")
    private  List<TemplateInfo> templatesList;

    @RequestField("授权生效时间")
    private LocalDateTime effectiveTime;

    @RequestField("授权失效时间")
    private LocalDateTime expireTime;


    public static class UserInfo{
        @RequestField("用户id")
        private Long userId;

        public Long getUserId() {
            return userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }
    }

    public static class TemplateInfo{
        @RequestField("模板id")
        private Long templateId;
        @RequestField("模板名称")
        private String templateName;

        public Long getTemplateId() {
            return templateId;
        }

        public void setTemplateId(Long templateId) {
            this.templateId = templateId;
        }

        public String getTemplateName() {
            return templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public Integer getAuthorMemberRange() {
        return authorMemberRange;
    }

    public void setAuthorMemberRange(Integer authorMemberRange) {
        this.authorMemberRange = authorMemberRange;
    }

    public List<UserInfo> getUserIdList() {
        return userIdList;
    }

    public void setUserIdList(List<UserInfo> userIdList) {
        this.userIdList = userIdList;
    }

    public String getAuthorRole() {
        return authorRole;
    }

    public void setAuthorRole(String authorRole) {
        this.authorRole = authorRole;
    }

    public Integer getAuthorRange() {
        return authorRange;
    }

    public void setAuthorRange(Integer authorRange) {
        this.authorRange = authorRange;
    }

    public List<TemplateInfo> getTemplatesList() {
        return templatesList;
    }

    public void setTemplatesList(List<TemplateInfo> templatesList) {
        this.templatesList = templatesList;
    }

    public LocalDateTime getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(LocalDateTime effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public LocalDateTime getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }
}
