package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.QueryCorpHasPayChannelResponse;

/**
 * @author dyl
 * 查询企业是否配置了支付渠道
 */
public class QueryCorpHasPayChannelReq extends BaseRequest<QueryCorpHasPayChannelResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payChannel/queryCorpHasPayChannel";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<QueryCorpHasPayChannelResponse> getResponseType() {
        return QueryCorpHasPayChannelResponse.class;
    }

    @RequestField("企业id")
    private Long corpId;

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
}
