package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderQueryResponse;

/**
 * @author dyl
 * 支付单查询
 */
public class GetPayOrderQueryReq extends BaseRequest<GetPayOrderQueryResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payOrder/query";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetPayOrderQueryResponse> getResponseType() {
        return GetPayOrderQueryResponse.class;
    }

    @RequestField(value = "支付单id")
    private Long id;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
