package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderListResponse;

import java.time.LocalDateTime;

/**
 * @author dyl
 * 支付单列表查询
 */
public class GetPayOrderListReq extends BasePageRequest<GetPayOrderListResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payOrder/listByPage";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetPayOrderListResponse> getResponseType() {
        return GetPayOrderListResponse.class;
    }


    @RequestField("支付单id")
    private Long id;

    @RequestField("订单类型(0：个人；1：企业)")
    private Integer orderType;

    @RequestField("支付单编码")
    private String orderCode;

    @RequestField("支付提供商(alipay-支付宝支付,wxpay-微信支付)")
    private String providerCode;

    @RequestField("支付类型(wxJSAPI-微信JSAPI支付,wxH5-微信H5支付,wxQrCode-微信二维码支付,alipayJSAPI-支付宝JSAPI支付,alipayPC-支付宝网站,alipayMobile-支付宝手机端,alipayPre-支付宝当面付)")
    private String payTypeCode;

    @RequestField("支付人id")
    private Long psnId;
    @RequestField("支付人")
    private String psnName;

    @RequestField("支付状态: 0-订单生成, 1-支付中, 2-支付成功, 3-支付失败, 4-已退款")
    private Integer status;

    @RequestField("业务单号")
    private String businessOrderNo;

    @RequestField("支付商品类型(0: 购买套餐；1：单合同签；2：支付收款合同款项；3：出证套餐)")
    private Integer goodsType;

    @RequestField("商品名称")
    private String goodsName;
    @RequestField("开始时间")
    private LocalDateTime beginTime;
    @RequestField("结束时间")
    private LocalDateTime endTime;
    @RequestField("外部单号(企业app过来的可以保留一个外部来源单号)")
    private String sourceOrderCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getProviderCode() {
        return providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    public String getPayTypeCode() {
        return payTypeCode;
    }

    public void setPayTypeCode(String payTypeCode) {
        this.payTypeCode = payTypeCode;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public LocalDateTime getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(LocalDateTime beginTime) {
        this.beginTime = beginTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }
}
