package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.GetPayOrderCreateResponse;
import com.yunyinsign.api.sdk.result.pay.GetPayUrlInfoRes;

/**
 * @author dyl
 * 创建支付单
 */
public class GetPayOrderCreateReq extends BaseRequest<GetPayOrderCreateResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payOrder/add";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetPayOrderCreateResponse> getResponseType() {
        return GetPayOrderCreateResponse.class;
    }


    @RequestField("支付通道ID")
    private Long channelModelId;

    @RequestField("合同参与方记录ID")
    private Long signerId;

    @RequestField("小程序openid")
    private String openId;

    @RequestField("重定向地址")
    private String returnUrl;

    @RequestField("来源：wx-小程序，alipay-支付宝小程序，h5-h5页面，alih5-支付宝h5页面，pc-pc端，wxh5-微信内h5页面")
    private String source;

    public Long getChannelModelId() {
        return channelModelId;
    }

    public void setChannelModelId(Long channelModelId) {
        this.channelModelId = channelModelId;
    }

    public Long getSignerId() {
        return signerId;
    }

    public void setSignerId(Long signerId) {
        this.signerId = signerId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
