package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.GetPayOpenIdResponse;

/**
 * @author dyl
 * 获取用户的openId
 */
public class GetPayOpenIdReq extends BaseRequest<GetPayOpenIdResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payChannel/getPayOpenId";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetPayOpenIdResponse> getResponseType() {
        return GetPayOpenIdResponse.class;
    }

    @RequestField("渠道id")
    private Long channelModelId;
    @RequestField("authCode")
    private String authCode;
    @RequestField("来源：wx-小程序，alipay-支付宝小程序，h5-h5页面，alih5-支付宝h5页面，pc-pc端，wxh5-微信内h5页面")
    private String source;

    public Long getChannelModelId() {
        return channelModelId;
    }

    public void setChannelModelId(Long channelModelId) {
        this.channelModelId = channelModelId;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
