package com.yunyinsign.api.sdk.request.pay;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.pay.GetPayChannelResponse;

/**
 * @author dyl
 * 查询流程支付渠道列表
 */
public class GetPayChannelReq extends BaseRequest<GetPayChannelResponse> {

    @Override
    public String getApiPath() {
        return "/pay/payChannel/queryChannelList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetPayChannelResponse> getResponseType() {
        return GetPayChannelResponse.class;
    }


    @RequestField("流程id")
    private Long flowId;
    @RequestField("来源：wx-小程序，alipay-支付宝小程序，h5-h5页面，alih5-支付宝h5页面，pc-pc端，wxh5-微信内h5页面")
    private String source;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
