package com.yunyinsign.api.sdk.request.member;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.member.MemberQueryResponse;

/**
 * @author dyl
 * 根据手机号/姓名查询
 */
public class MemberQueryReq extends BaseRequest<MemberQueryResponse> {
    @Override
    public String getApiPath() {
        return "/member/infoByMobileOrName";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<MemberQueryResponse> getResponseType() {
        return MemberQueryResponse.class;
    }

    @RequestField("查询参数，支持手机号、姓名查询")
    private String paramString;


    public String getParamString() {
        return paramString;
    }
    public void setParamString(String paramString) {
        this.paramString = paramString;
    }

}
