package com.yunyinsign.api.sdk.request.member;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.member.MemberInfoQueryResponse;

/**
 * @author dyl
 * 查询企业成员信息
 */
public class MemberInfoQueryReq extends BaseRequest<MemberInfoQueryResponse> {
    @Override
    public String getApiPath() {
        return "/member/infoByCorpId";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<MemberInfoQueryResponse> getResponseType() {
        return MemberInfoQueryResponse.class;
    }

    @RequestField("用户ID")
    private Long userId;

    @RequestField("用户名称（昵称）")
    private String userName;

    @RequestField("手机号")
    private String mobile;

    @RequestField("实名状态(0：未实名；1：已实名)")
    private Integer realNameStatus;

    public Long getUserId() {
        return userId;
    }
    public void setUserId(Long userId) {
        this.userId = userId;
    }
    public String getUserName() {
        return userName;
    }
    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getMobile() {
        return mobile;
    }
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    public Integer getRealNameStatus() {
        return realNameStatus;
    }
    public void setRealNameStatus(Integer realNameStatus) {
        this.realNameStatus = realNameStatus;
    }
}
