package com.yunyinsign.api.sdk.request.member;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.member.MemberAuthResponse;

/**
 * @author dyl
 * 个人认证更新
 */
public class MemberAuthReq extends BaseRequest<MemberAuthResponse> {
    @Override
    public String getApiPath() {
        return "/member/memberAuth";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<MemberAuthResponse> getResponseType() {
        return MemberAuthResponse.class;
    }


    @RequestField("真实姓名")
    private String realName;

    @RequestField("证件号码")
    private String identNum;

    @RequestField("签署密码(6位数字)")
    private Integer signPwd;

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getIdentNum() {
        return identNum;
    }

    public void setIdentNum(String identNum) {
        this.identNum = identNum;
    }

    public Integer getSignPwd() {
        return signPwd;
    }

    public void setSignPwd(Integer signPwd) {
        this.signPwd = signPwd;
    }
}
