package com.yunyinsign.api.sdk.request.member;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.member.DeleteMemberResponse;

/**
 * @author dyl
 * 删除会员
 */
public class DeleteMemberReq extends BaseRequest<DeleteMemberResponse> {
    @Override
    public String getApiPath() {
        return "/member/delete";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<DeleteMemberResponse> getResponseType() {
        return DeleteMemberResponse.class;
    }

    @RequestField("用户ID")
    private Long userId;


    public Long getUserId() {
        return userId;
    }
    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
