package com.yunyinsign.api.sdk.request.member;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.member.CreateMemberResponse;

/**
 * @author dyl
 * 添加人员
 */
public class CreateMemberReq extends BaseRequest<CreateMemberResponse> {
    @Override
    public String getApiPath() {
        return "/member/create";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<CreateMemberResponse> getResponseType() {
        return CreateMemberResponse.class;
    }

    @RequestField("工号")
    private String jobNum;

    @RequestField("用户名称（昵称）")
    private String userName;

    @RequestField("手机号")
    private String mobile;

    public String getJobNum() {
        return jobNum;
    }
    public void setJobNum(String jobNum) {
        this.jobNum = jobNum;
    }
    public String getUserName() {
        return userName;
    }
    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getMobile() {
        return mobile;
    }
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
}
