package com.yunyinsign.api.sdk.request.fetch;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.fetch.GetFetchAuthUrlResponse;

/**
 * @author dyl
 * 公共方法获取个人人脸认证地址
 */
public class GetFetchAuthUrlReq extends BaseRequest<GetFetchAuthUrlResponse> {
    @Override
    public String getApiPath() {
        return "/fetchAuth/faceAuth";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetFetchAuthUrlResponse> getResponseType() {
        return GetFetchAuthUrlResponse.class;
    }


    @RequestField("对应业务单id，个人认证回调传用户id、法人认证回调传企业id、签署合同传合同id、审批签署传审批id（批量业务单id以逗号分隔）、找回企业回调传企业id。")
    private String id;

    @RequestField("人脸认证类型，目前支持：person-个人认证回调，legal-法人认证回调，signContract-签署合同，approvalSign-审批签署,receiveCorp-找回企业。")
    private String authType;

    @RequestField("渠道 tencent - 腾讯； cdp - 数据宝")
    private String channel;

    @RequestField("回调地址")
    private String callbackUrl;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }
}
