package com.yunyinsign.api.sdk.request.corp;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.corp.GetAccountHistoryQueryResponse;

import java.time.LocalDateTime;

/**
 * @author dyl
 * 查询企业账户流水记录
 */
public class GetAccountHistoryQueryReq extends BasePageRequest<GetAccountHistoryQueryResponse> {
    @Override
    public String getApiPath() {
        return "/corp/queryAccountHistoryList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetAccountHistoryQueryResponse> getResponseType() {
        return GetAccountHistoryQueryResponse.class;
    }


    @RequestField("合同流程编码")
    private String signFlowCode;

    @RequestField("合同流程名称")
    private String signFlowName;

    @RequestField("发起人名称")
    private String initPsnName;

    @RequestField("流水类型：newUserPresent-新用户赠送,signContract-签合同扣减,signCancel-签合同撤销,orderBuy-订单购买,adminRecharge-后台充值,adminContract-后台扣减,orderExpire-订单过期失效,crmOrderPresent-Crm套餐赠送,crmOrderBuy-Crm订单购买,reverseReturn-对方付返还")
    private String recordType;

    @RequestField("套餐编码")
    private String orderCode;

    @RequestField("开始时间")
    private LocalDateTime beginTime;
    @RequestField("结束时间")
    private LocalDateTime endTime;

    public String getSignFlowCode() {
        return signFlowCode;
    }

    public void setSignFlowCode(String signFlowCode) {
        this.signFlowCode = signFlowCode;
    }

    public String getSignFlowName() {
        return signFlowName;
    }

    public void setSignFlowName(String signFlowName) {
        this.signFlowName = signFlowName;
    }

    public String getInitPsnName() {
        return initPsnName;
    }

    public void setInitPsnName(String initPsnName) {
        this.initPsnName = initPsnName;
    }

    public String getRecordType() {
        return recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public LocalDateTime getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(LocalDateTime beginTime) {
        this.beginTime = beginTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }
}
