package com.yunyinsign.api.sdk.request.bill;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.bill.GetSignFlowPayeeBillRefundResponse;

import java.math.BigDecimal;

/**
 * @author dyl
 * 收款单发起退款
 */
public class GetSignFlowPayeeBillRefundReq extends BaseRequest<GetSignFlowPayeeBillRefundResponse> {

    @Override
    public String getApiPath() {
        return "/signFlowBill/refund";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowPayeeBillRefundResponse> getResponseType() {
        return GetSignFlowPayeeBillRefundResponse.class;
    }

    @RequestField(value="参与方id")
    private Long participateId;

    @RequestField(value="退款金额")
    private BigDecimal refundAmount;

    @RequestField(value="退款原因")
    private String refundReason;

    @RequestField(value="来源订单号")
    private String sourceOrderCode;

    public Long getParticipateId() {
        return participateId;
    }

    public void setParticipateId(Long participateId) {
        this.participateId = participateId;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }
}
