package com.yunyinsign.api.sdk.request.bill;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.bill.GetSignFlowPayeeBillQueryResponse;

import java.util.Date;

/**
 * @author dyl
 * 收款合同账单查询
 */
public class GetSignFlowPayeeBillQueryReq extends BasePageRequest<GetSignFlowPayeeBillQueryResponse> {

    @Override
    public String getApiPath() {
        return "/signFlowBill/payeeBillList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowPayeeBillQueryResponse> getResponseType() {
        return GetSignFlowPayeeBillQueryResponse.class;
    }

    @RequestField(value="流程ID")
    private Long  flowId;

    @RequestField(value="合同号")
    private String contractCode;

    @RequestField(value="支付单号")
    private String payOrderCode;

    @RequestField(value="参与方类型 1-企业 0-个人")
    private Integer participantType;

    @RequestField(value="付款方（根据参与方类型选择个人或企业）")
    private String payName;

    @RequestField(value="收款方企业名称")
    private String payeeCorpName;

    @RequestField(value="收款方")
    private String payeeName;
    @RequestField(value="渠道单号")
    private String channelOrderNo;

    @RequestField(value="支付状态 1-待支付 2-支付成功  3-退款成功")
    private Integer payStatus;

    @RequestField(value="签署流程开启时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date flowStartTime;

    @RequestField(value="签署流程结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date flowFinishTime;

    @RequestField(value="来源订单号")
    private String sourceOrderCode;


    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getPayOrderCode() {
        return payOrderCode;
    }

    public void setPayOrderCode(String payOrderCode) {
        this.payOrderCode = payOrderCode;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public String getPayName() {
        return payName;
    }

    public void setPayName(String payName) {
        this.payName = payName;
    }

    public String getPayeeCorpName() {
        return payeeCorpName;
    }

    public void setPayeeCorpName(String payeeCorpName) {
        this.payeeCorpName = payeeCorpName;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getChannelOrderNo() {
        return channelOrderNo;
    }

    public void setChannelOrderNo(String channelOrderNo) {
        this.channelOrderNo = channelOrderNo;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Date getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(Date flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public Date getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(Date flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }
}
