package com.yunyinsign.api.sdk.model.vo;

import com.yunyinsign.api.sdk.internal.mapping.RequestField;

import java.math.BigDecimal;

/**
 * @author dyl
 * 模板控件
 */
public class TemplateComponentReq {

    @RequestField(value = "控件ID. 新增不需要")
    private Long componentId;

    @RequestField(value = "参与方ID")
    private Long participantId;

    @RequestField(value = "合同文档ID")
    private Long contractFileId;

    @RequestField(value = "控件Key（设置文件模板时由用户自定义）")
    private String componentKey;

    @RequestField(value = "控件名称（设置文件模板时由用户自定义）")
    private String componentName;

    @RequestField(value = "控件类型：1 - 单行文本，2 - 数字，3 - 日期，6 - 签章区域，8 - 多行文本，9 - 复选，10 - 单选，11 - 图片，14 -下拉框，15 - 勾选框，16 - 身份证，17 - 备注区域，18 - 动态表格，19 - 手机号")
    private Integer componentType;

    @RequestField(value = "控件默认值（页面中文本控件或数字控件中设置的默认值）")
    private String value;

    @RequestField(value = "控件是否必填：1 - 必填；0- 非必填")
    private Integer required;

    @RequestField(value = "X横坐标")
    private BigDecimal positionX;

    @RequestField(value = "Y纵坐标值")
    private BigDecimal positionY;

    @RequestField(value = "控件所在页码")
    private Integer pageNum;

    /**
     * 控件特有属性：{"dateFormat": "日期格式yyyy-MM-dd HH:mm:ss","imageType":"图片类型:IDCard_widthwise（身份证横向等比缩放大小）;IDCard_longitudinal（身份证纵向等比缩放大小）;other （其他，自由缩放大小）","tableContent":[{"表格行列内容（动态表格控件特有），格式： [row{"column1":"value1","column2":"value2"}]}
     */
    @RequestField(value = "控件特有属性")
    private TemplateCompSpecialAttrReq specialAttribute;

    public Long getComponentId() {
        return componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getComponentKey() {
        return componentKey;
    }

    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Integer getComponentType() {
        return componentType;
    }

    public void setComponentType(Integer componentType) {
        this.componentType = componentType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public BigDecimal getPositionX() {
        return positionX;
    }

    public void setPositionX(BigDecimal positionX) {
        this.positionX = positionX;
    }

    public BigDecimal getPositionY() {
        return positionY;
    }

    public void setPositionY(BigDecimal positionY) {
        this.positionY = positionY;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public TemplateCompSpecialAttrReq getSpecialAttribute() {
        return specialAttribute;
    }

    public void setSpecialAttribute(TemplateCompSpecialAttrReq specialAttribute) {
        this.specialAttribute = specialAttribute;
    }
}
