package com.yunyinsign.api.sdk.model.vo;

import com.yunyinsign.api.sdk.internal.mapping.RequestField;

/**
 * @author dyl
 * 控件特有属性
 */
public class TemplateCompSpecialAttrReq {

    /**
     * 日期格式： yyyy年MM月dd日 ; yyyy-MM-dd HH:mm:ss;yyyy-MM-dd
     */
    @RequestField(value = "日期格式： yyyy年MM月dd日 ; yyyy-MM-dd HH:mm:ss;yyyy-MM-dd")
    public String dateFormat;
    /**
     * 数字格式
     */
    @RequestField(value = "数字格式")
    public String numberFormat;

    /**
     * 小数位数
     */
    @RequestField(value = "小数位数")
    public String fractionDigits;


    /**
     * 填充长度上限（多少个中文字符）
     */
    @RequestField(value = "填充长度上限（多少个中文字符）")
    public String maxLength;

    /**
     * 字体
     */
    @RequestField(value = "字体（SimSun-宋体；FangSong-仿宋；KaiTi-楷体；SimHei-黑体）")
    public String font;

    /**
     * 字体大小
     */
    @RequestField(value = "字体大小")
    public Integer fontSize;

    /**
     * 颜色
     */
    @RequestField(value = "字体颜色")
    private String textColor;

    /**
     * 粗体
     */
    @RequestField(value = "是否粗体")
    private Boolean bold;

    /**
     * 斜体
     */
    @RequestField(value = "是否斜体")
    private boolean italic;

    /**
     * 下划线
     */
    @RequestField(value = "是否下划线")
    private boolean underLine;

    /**
     * 中划线
     */
    @RequestField(value = "是否中划线")
    private boolean lineThrough;

    /**
     * 对其方式
     */
    @RequestField(value = "对齐方式（0-居左；1-居中；3-居右）")
    public int alignment;


    /*************** 前端定义属性  ***************/
    /**
     * 前端定义类型，类型 'mobileNumber'
     */
    @RequestField(value = "前端定以：控件类型")
    private String type;
    /**
     * 图标
     */
    @RequestField(value = "前端定以：控件图标名称")
    private String tagIcon;

    /**
     * 控件宽度（矩形的左右边距距离，单位为px）
     */
    @RequestField(value = "控件宽度")
    private Integer width;

    /**
     * 控件高度（矩形的上下边距距离，单位为px）
     */
    @RequestField(value = "控件高度")
    private Integer height;

    @RequestField(value = "顺序")
    private int order;


    /** ************ 签章数据 *******************************/
    /**
     * 是否显示签署日期: 0 - 不显示; 1 - 显示
     */
    @RequestField(value = "签章是否显示签署日期：0 - 不显示; 1 - 显")
    public int showSignDate;

    /**
     * 签章区样式: 1-单页签章区； 2-骑缝签章区
     */
    @RequestField(value = "签章区样式：1-单页签章区； 2-骑缝签章区")
    public Integer signStyle;

    /**
     * 落章规则: 1-以实际印章规格加盖； 2-自定义印章规格加盖（根据指定的签署区宽高适配
     */
    @RequestField(value = "落章规则: 1-以实际印章规格加盖； 2-自定义印章规格加盖（根据指定的签署区宽高适）")
    public Integer sealSpecs;


    /**
     * 下拉选项
     */
    public static class Option {
        /**
         * 顺序
         */
        @RequestField("order")
        private int order;

        /**
         * 内容
         */
        @RequestField("content")
        private String content;

        /**
         * 是否选中
         */
        @RequestField("selected")
        private boolean selected;

        public int getOrder() {
            return order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean getSelected() {
            return selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getNumberFormat() {
        return numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getFractionDigits() {
        return fractionDigits;
    }

    public void setFractionDigits(String fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public String getFont() {
        return font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public Integer getFontSize() {
        return fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public String getTextColor() {
        return textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public Boolean getBold() {
        return bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public boolean getItalic() {
        return italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean getUnderLine() {
        return underLine;
    }

    public void setUnderLine(boolean underLine) {
        this.underLine = underLine;
    }

    public boolean getLineThrough() {
        return lineThrough;
    }

    public void setLineThrough(boolean lineThrough) {
        this.lineThrough = lineThrough;
    }

    public int getAlignment() {
        return alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTagIcon() {
        return tagIcon;
    }

    public void setTagIcon(String tagIcon) {
        this.tagIcon = tagIcon;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getShowSignDate() {
        return showSignDate;
    }

    public void setShowSignDate(int showSignDate) {
        this.showSignDate = showSignDate;
    }

    public Integer getSignStyle() {
        return signStyle;
    }

    public void setSignStyle(Integer signStyle) {
        this.signStyle = signStyle;
    }

    public Integer getSealSpecs() {
        return sealSpecs;
    }

    public void setSealSpecs(Integer sealSpecs) {
        this.sealSpecs = sealSpecs;
    }
}
