package com.yunyinsign.api.sdk.model.vo;

import com.yunyinsign.api.sdk.internal.mapping.RequestField;

import java.util.List;

/**
 * 模板参与人信息
 * @author dyl
 */
public class GetTemplateParticipantReq {
    @RequestField("参与方ID")
    private Long participantId;

    @RequestField("模板ID")
    private Long templateId;

    @RequestField("参与方标识，同一个模板中不可重复， 会展示到模板页面上，例如甲方、乙方等容易理解的业务名词")
    private String participantFlag;

    @RequestField("参与方类型 1-企业 2-个人")
    private Integer participantType;

    @RequestField("参与方式：1-填写 2-签署")
    private List<String> participateBizType;

    @RequestField("参与方取值方式： 0-使用模版指定； 1- 固定成员； 3-发起人本人")
    private Integer participantSetMode;

    @RequestField("经办人手机")
    private String psnAccount;

    @RequestField("经办人名称")
    private String psnName;
    /**
     * 填写顺序， 1-255 不同参与人不可重复
     */
    @RequestField("填写顺序，默认值1： 1-255 不同参与人不可重复")
    private Integer draftSort;

    /**
     * 签署顺序，默认值1： 1-255 不同参与人可重复
     */
    @RequestField("签署顺序， 1-255 不同参与人可重复")
    private Integer signOrder;

    @RequestField("参与方企业名称（个人类型时为空）")
    private String participantCorpName;

    @RequestField("是否需要收款（0：否；1：是）")
    private Integer payeeContractFlag;

    @RequestField("收款信息")
    private GetTemplatePayeeReq payee;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getParticipantFlag() {
        return participantFlag;
    }

    public void setParticipantFlag(String participantFlag) {
        this.participantFlag = participantFlag;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public List<String> getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(List<String> participateBizType) {
        this.participateBizType = participateBizType;
    }

    public Integer getParticipantSetMode() {
        return participantSetMode;
    }

    public void setParticipantSetMode(Integer participantSetMode) {
        this.participantSetMode = participantSetMode;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Integer getDraftSort() {
        return draftSort;
    }

    public void setDraftSort(Integer draftSort) {
        this.draftSort = draftSort;
    }

    public Integer getSignOrder() {
        return signOrder;
    }

    public void setSignOrder(Integer signOrder) {
        this.signOrder = signOrder;
    }

    public String getParticipantCorpName() {
        return participantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        this.participantCorpName = participantCorpName;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public GetTemplatePayeeReq getPayee() {
        return payee;
    }

    public void setPayee(GetTemplatePayeeReq payee) {
        this.payee = payee;
    }
}
