package com.yunyinsign.api.sdk.model.dto;

import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.TemplateCompSpecialAttrReq;

import java.math.BigDecimal;

/**
 * @author dyl
 * 签署组件
 */
public class SignComponentCmd {

    @RequestField(value="组件ID")
    private Long componentId;

    @RequestField(value="参与方ID")
    private Long participantId;

    @RequestField(value="合同文档ID")
    private Long contractFileId;

    @RequestField(value="签署区类型，默认值为 0：0 - 签章区 （添加印章、签名等）；1 - 备注区（添加备注文字信息等）；2 - 独立签署日期（添加单独的签署日期）")
    private Integer fieldType;

    @RequestField(value="X横坐标")
    private BigDecimal positionX;

    @RequestField(value="Y纵坐标值")
    private BigDecimal positionY;

    @RequestField(value="页码")
    private Integer pageNum;
    @RequestField(value="签名的印章ID")
    private Long sealId;
    /**
     * {"dateFormat":"日期格式:yyyy年MM月dd日（默认值）","fontSize":"日期字体大小，默认值12px","datePage":"指定签署日期位置页码","positionX":"X坐标", "positionY":"Y坐标"}
     */
    @RequestField(value = "控件特有属性")
    private TemplateCompSpecialAttrReq specialAttribute;

    public Long getComponentId() {
        return componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Integer getFieldType() {
        return fieldType;
    }

    public void setFieldType(Integer fieldType) {
        this.fieldType = fieldType;
    }

    public BigDecimal getPositionX() {
        return positionX;
    }

    public void setPositionX(BigDecimal positionX) {
        this.positionX = positionX;
    }

    public BigDecimal getPositionY() {
        return positionY;
    }

    public void setPositionY(BigDecimal positionY) {
        this.positionY = positionY;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public TemplateCompSpecialAttrReq getSpecialAttribute() {
        return specialAttribute;
    }

    public void setSpecialAttribute(TemplateCompSpecialAttrReq specialAttribute) {
        this.specialAttribute = specialAttribute;
    }
}
